/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CString.cpp,v 1.3 1999/12/12 07:08:56 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include <stdio.h>

#include "CString.h"

_USING_PGP

// Class CString member functions

CString::CString() : mCharArray(kDefaultStringSize)
{
#if !PGP_EXCEPTIONS
	Status() = mCharArray.Status();

	if (Status().IsntError())
#endif	// !PGP_EXCEPTIONS
		Init();
}

CString::CString(const CString& cstr)
{
#if !PGP_EXCEPTIONS

	Status() = mCharArray.Status();

	if (Status().IsntError())
	{
		Init();
		Status() = Assign(cstr);
	}

#else	// PGP_EXCEPTIONS

	Init();
	Assign(cstr);

#endif	// !PGP_EXCEPTIONS
}

CString::CString(const char *str) : mCharArray(kDefaultStringSize)
{
	pgpAssertStrValid(str);

#if !PGP_EXCEPTIONS

	Status() = mCharArray.Status();

	if (Status().IsntError())
	{
		Init();
		Status() = Assign(str);
	}

#else	// PGP_EXCEPTIONS

	Init();
	Assign(str);

#endif	// !PGP_EXCEPTIONS
}

CString::CString(char c) : mCharArray(kDefaultStringSize)
{
#if !PGP_EXCEPTIONS

	Status() = mCharArray.Status();

	if (Status().IsntError())
	{
		Init();
		Status() = Assign(c);
	}

#else	// PGP_EXCEPTIONS

	Init();
	Assign(c);

#endif	// !PGP_EXCEPTIONS
}

CString& 
CString::operator=(const CString& cstr)
{
#if !PGP_EXCEPTIONS
	Status() = Assign(cstr);
#else	// PGP_EXCEPTIONS
	Assign(cstr);
#endif	// !PGP_EXCEPTIONS

	return *this;
}

CString& 
CString::operator=(const char *str)
{
	pgpAssertStrValid(str);

#if !PGP_EXCEPTIONS
	Status() = Assign(str);
#else	// PGP_EXCEPTIONS
	Assign(str);
#endif	// !PGP_EXCEPTIONS

	return *this;
}

CString& 
CString::operator=(char c)
{
#if !PGP_EXCEPTIONS
	Status() = Assign(c);
#else	// PGP_EXCEPTIONS
	Assign(c);
#endif	// !PGP_EXCEPTIONS

	return *this;
}

CString& 
CString::operator+=(const char *str)
{
	pgpAssertStrValid(str);

#if !PGP_EXCEPTIONS
	Status() = Append(str);
#else	// PGP_EXCEPTIONS
	Append(str);
#endif	// !PGP_EXCEPTIONS

	return *this;
}

CString& 
CString::operator+=(char c)
{
#if !PGP_EXCEPTIONS
	Status() = Append(c);
#else	// PGP_EXCEPTIONS
	Append(c);
#endif	// !PGP_EXCEPTIONS

	return *this;
}

PGPUInt32 
CString::Length() const
{
	return (strlen(mCharArray.Get()));
}

PGPBoolean 
CString::Compare(const char *str) const
{
	pgpAssertStrValid(str);
	return (strcmp(str, mCharArray.Get()) == 0);
}

PGPBoolean 
CString::CompareNoCase(const char *str) const
{
	pgpAssertStrValid(str);
	return (_stricmp(str, mCharArray.Get()) == 0);
}

PGPInt32 
CString::Find(char c, PGPUInt32 nth) const
{
	PGPUInt32	i, n;

	for (i = 0, n = 0; i < Length(); i++)
	{
		if (GetAt(i) == c)
		{
			if (++n == nth)
				return i;
		}
	}

	return -1;
}

PGPInt32 
CString::Find(const char *str, PGPUInt32 nth) const
{
	pgpAssertStrValid(str);

	const char	*last	= Get();
	PGPUInt32	n		= 0;

	do
	{
		 const char	*cur	= strstr(last, str);

		 if (IsNull(cur))
			 return -1;

		 if (++n == nth)
			 return (cur - Get());

		 last = cur + 1;
	}
	while (*last != '\0');

	return -1;
}

PGPInt32 
CString::ReverseFind(char c, PGPUInt32 nth) const
{
	PGPUInt32	i, n;

	for (i = Length() - 1, n = 0; i > 0; i--)
	{
		if (GetAt(i) == c)
		{
			if (++n == nth)
				return i;
		}
	}

	return -1;
}

SMART_ERROR 
CString::Left(PGPUInt32 i, CString& cstr) const
{
	pgpAssert(i <= Length());

	SMART_ERROR_DECLARE

#if PGP_EXCEPTIONS
	char	*strBuf	= cstr.GetBuffer(i + 1);
#else	// !PGP_EXCEPTIONS
	char	*strBuf;
	error = cstr.GetBuffer(i + 1, strBuf);

	if (error.IsntError())
#endif	// PGP_EXCEPTIONS
	{
		strncpy(strBuf, mCharArray.Get(), i);
		strBuf[i] = '\0';

		cstr.ReleaseBuffer();
	}

	SMART_ERROR_RETURN
}

SMART_ERROR 
CString::Mid(PGPUInt32 i, PGPUInt32 j, CString& cstr) const
{
	pgpAssert(j > i);
	pgpAssert(i <= Length());
	pgpAssert(j <= Length());

	SMART_ERROR_DECLARE

#if PGP_EXCEPTIONS
	char	*strBuf	= cstr.GetBuffer(j - i + 1);
#else	// !PGP_EXCEPTIONS
	char	*strBuf;
	error = cstr.GetBuffer(j - i + 1, strBuf);

	if (error.IsntError())
#endif	// PGP_EXCEPTIONS
	{
		strncpy(strBuf, mCharArray.Get() + i, j - i + 1);
		strBuf[j - i + 1] = '\0';

		cstr.ReleaseBuffer();
	}

	SMART_ERROR_RETURN
}

SMART_ERROR 
CString::Right(PGPUInt32 i, CString& cstr) const
{
	pgpAssert(i <= Length());

	SMART_ERROR_DECLARE

#if PGP_EXCEPTIONS
	char	*strBuf	= cstr.GetBuffer(i + 1);
#else	// !PGP_EXCEPTIONS
	char	*strBuf;
	error = cstr.GetBuffer(i + 1, strBuf);

	if (error.IsntError())
#endif	// PGP_EXCEPTIONS
	{
		strncpy(strBuf, mCharArray.Get() + Length() - i, i);
		strBuf[i] = '\0';

		cstr.ReleaseBuffer();
	}

	SMART_ERROR_RETURN
}

#if PGP_EXCEPTIONS

char * 
CString::GetBuffer(PGPUInt32 bufSize)
{
	Resize(bufSize);
	return mCharArray.Get();
}

#else	// !PGP_EXCEPTIONS

CComboError 
CString::GetBuffer(PGPUInt32 bufSize, char *&buf)
{
	CComboError	error;

	error = Resize(bufSize);

	if (error.IsntError())
		buf = mCharArray.Get();

	return error;
}

#endif	// PGP_EXCEPTIONS

void 
CString::ReleaseBuffer()
{
	// Must be a valid string.
	pgpAssertStrValid(mCharArray.Get());

	// Nothing to do.
}

void 
CString::Empty()
{
	mCharArray[0] = '\0';
}

SMART_ERROR 
CString::Assign(const char *str)
{
	pgpAssertStrValid(str);

	SMART_ERROR_DECLARE

	if (mCharArray.Get() == str)
		SMART_ERROR_RETURN

	PGPUInt32	newLength	= strlen(str);

	SMART_ERROR_ASSIGN Resize(newLength);

#if !PGP_EXCEPTIONS
	if (error.IsntError())
#endif	// !PGP_EXCEPTIONS
		strcpy(mCharArray.Get(), str);

	SMART_ERROR_RETURN
}

SMART_ERROR 
CString::Assign(char c)
{
	char	charStr[2]	= {c, '\0'};
	SMART_ERROR_CALL Assign(charStr);
}

SMART_ERROR 
CString::Append(const char *str)
{
	pgpAssertStrValid(str);

	SMART_ERROR_DECLARE

	if (mCharArray.Get() == str)
		SMART_ERROR_RETURN

	PGPUInt32	newLength	= Length() + strlen(str);

	SMART_ERROR_ASSIGN Resize(newLength);

#if !PGP_EXCEPTIONS
	if (error.IsntError())
#endif	// !PGP_EXCEPTIONS
		strcat(mCharArray.Get(), str);

	SMART_ERROR_RETURN
}

SMART_ERROR 
CString::Append(char c)
{
	char	charStr[2]	= {c, '\0'};
	SMART_ERROR_CALL Append(charStr);
}

SMART_ERROR 
CString::Prepend(const char *str)
{
	pgpAssertStrValid(str);

	SMART_ERROR_DECLARE

	if (mCharArray.Get() == str)
		SMART_ERROR_RETURN

	PGPUInt32	newLength	= Length() + strlen(str);

	SMART_ERROR_ASSIGN Resize(newLength);

#if !PGP_EXCEPTIONS
	if (error.IsntError())
#endif	// !PGP_EXCEPTIONS
	{
		CString	tempString(mCharArray.Get());

	#if !PGP_EXCEPTIONS
		error = tempString.Status();

		if (error.IsntError())
	#endif	// !PGP_EXCEPTIONS
		{
			strcpy(mCharArray.Get(), str);
			strcat(mCharArray.Get(), tempString);
		}
	}

	SMART_ERROR_RETURN
}

SMART_ERROR 
CString::Prepend(char c)
{
	char	charStr[2]	= {c, '\0'};
	SMART_ERROR_CALL Prepend(charStr);
}

void 
CString::Uppercase()
{
	for (PGPUInt32 i = 0; i < Length(); i++)
	{
		mCharArray[i] = toupper(mCharArray[i]);
	}
}

void 
CString::Lowercase()
{
	for (PGPUInt32 i = 0; i < Length(); i++)
	{
		mCharArray[i] = tolower(mCharArray[i]);
	}
}

SMART_ERROR 
CString::Format(const char *formatStr, ...)
{
	pgpAssertStrValid(formatStr);

	SMART_ERROR_DECLARE

	va_list	argList;
	va_start(argList, formatStr);

	SMART_ERROR_ASSIGN Resize(kMaxFormatStrSize);

#if !PGP_EXCEPTIONS
	if (error.IsntError())
#endif	// !PGP_EXCEPTIONS
		_vsnprintf(mCharArray.Get(), kMaxFormatStrSize, formatStr, argList);

	va_end(argList);

	SMART_ERROR_RETURN
}

SMART_ERROR 
CString::Resize(PGPUInt32 newSize)
{
	SMART_ERROR_DECLARE

	SMART_ERROR_ASSIGN mCharArray.Resize(newSize + 1);

#if !PGP_EXCEPTIONS
	if (error.IsntError())
#endif	// !PGP_EXCEPTIONS
		mCharArray[newSize] = '\0';

	SMART_ERROR_RETURN
}

void 
CString::Init()
{
	mCharArray[0] = '\0';
}
